# Enterlife Core

A simple, lightweight PHP application for personal well-being.

## Requirements

- PHP 8.1+
- MySQL 8.0+ (or Postgres when using `DB_DRIVER=pgsql`)
- Web Server (Apache, Nginx, or PHP built-in server)

## Installation

1. **Database Setup**
   - Create a new MySQL/Postgres database (e.g., `enterlife`).
   - Import the schema from `database/schema.sql`.

2. **Configuration**
   - Copy `includes/config.example.php` to `includes/config.php`.
   - Prefer environment variables for secrets: `DB_HOST`, `DB_PORT`, `DB_NAME`, `DB_USER`, `DB_PASS`, `BASE_URL`. Optional: `DB_DSN` (full DSN) and `DB_DRIVER` for non-MySQL setups (e.g., Supabase Postgres).
   - If you keep values in `config.php`, avoid committing real passwords.

3. **Running Locally**
   - Open a terminal in the project root.
   - Run: `php -S localhost:8000 -t public_html`
   - Visit `http://localhost:8000` in your browser (so you can see it online locally).

4. **Deployment (cPanel/Shared Hosting)**
   - Upload all files to your `public_html` or a subdirectory.
   - Create a database and user in cPanel.
   - Import `database/schema.sql` via phpMyAdmin.
   - Update `includes/config.php` with production credentials.
   - Ensure `public_html` is the document root, or adjust paths accordingly.

## Folder Structure

- `public_html/`: Publicly accessible files (index, css, js).
- `includes/`: Core logic, models, controllers (secure this folder in production if possible).
- `templates/`: View templates.
- `admin/`: Admin interface.
- `database/`: SQL schema.

## Features

- User Authentication (Register/Login)
- Dashboard with Stats
- Articles (Read & Admin Manage)
- Tools (Eye Exercises, Focus Timer, Breathing)
- Quotes System

## Supabase (optional for tests)

- Export your Supabase personal access token and project keys as environment variables (do **not** commit them): `SUPABASE_ACCESS_TOKEN`, `SUPABASE_URL`, and `SUPABASE_SERVICE_ROLE_KEY` (or `SUPABASE_ANON_KEY` for read-only checks).
- Example (PowerShell):  
  `$env:SUPABASE_ACCESS_TOKEN="sbp_..."; $env:SUPABASE_URL="https://<project>.supabase.co"; $env:SUPABASE_SERVICE_ROLE_KEY="ey..."`  
  (replace the placeholders with your real values).
- Run the smoke test to verify connectivity: `php tests/supabase_smoke.php`.
- The app still uses MySQL/Postgres for primary data; Supabase is wired only for external/test checks.

## Tests

- Model/Auth smoke (SQLite, non-destructive):  
  `DB_DSN=sqlite::memory: php tests/model_smoke.php`
- Supabase smoke (external): `php tests/supabase_smoke.php` with the Supabase env vars set.
