-- Initialize default site_settings values
-- Run this script once to populate the site_settings table with defaults

INSERT INTO site_settings (setting_key, setting_value, created_at) VALUES
-- SEO Settings
('default_meta_title', 'Enterlife - Eye Care, Focus & Wellness Platform', NOW()),
('default_meta_description', 'Improve your vision and mental focus with science-backed exercises, tools, and wellness content.', NOW()),
('default_og_image', '/assets/img/og-default.jpg', NOW()),
('default_twitter_card_type', 'summary_large_image', NOW()),
('site_schema_org_type', 'WebSite', NOW()),
('robots_txt_content', 'User-agent: *\nAllow: /', NOW()),

-- Marketing & Tracking (disabled by default)
('tracking_enabled', '1', NOW()),
('ga4_measurement_id', '', NOW()),
('gtm_container_id', '', NOW()),
('adsense_client_id', '', NOW()),
('adsense_code_head', '', NOW()),
('adsense_code_body', '', NOW()),
('facebook_pixel_id', '', NOW()),
('custom_head_scripts', '', NOW()),
('custom_body_scripts', '', NOW()),

-- Email & Newsletter
('smtp_host', '', NOW()),
('smtp_port', '587', NOW()),
('smtp_username', '', NOW()),
('smtp_password', '', NOW()),
('newsletter_from_name', 'Enterlife Team', NOW()),
('newsletter_from_email', 'newsletter@enterlife.com', NOW()),
('newsletter_enabled', '1', NOW()),

-- General Site
('site_name', 'Enterlife', NOW()),
('site_tagline', 'Vision & Focus Wellness Platform', NOW()),
('contact_email', 'support@enterlife.com', NOW()),
('maintenance_mode', '0', NOW())
ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value);

-- Create default subscription plans if they don't exist
INSERT INTO subscription_plans (plan_name, plan_slug, description, price, currency, billing_cycle, is_active, created_at) VALUES
('Free', 'free', 'Basic access to free content and tools', 0.00, 'USD', 'lifetime', 1, NOW()),
('PRO', 'pro', 'Full access to all premium content, tools, and magazines', 9.99, 'USD', 'monthly', 1, NOW()),
('PRO Annual', 'pro_annual', 'Full access to all premium content with annual billing', 99.00, 'USD', 'yearly', 1, NOW())
ON DUPLICATE KEY UPDATE plan_name = VALUES(plan_name);

-- Create default content categories
INSERT INTO content_categories (category_name, slug, description, display_order, created_at) VALUES
('Eye Health', 'eye-health', 'Articles and resources about eye health and vision care', 1, NOW()),
('Focus & Productivity', 'focus-productivity', 'Tools and tips for improving mental focus and productivity', 2, NOW()),
('Breathing Exercises', 'breathing', 'Breathing techniques and exercises for wellness', 3, NOW()),
('Wellness', 'wellness', 'General health and wellness content', 4, NOW()),
('Mental Health', 'mental-health', 'Mental health resources and support', 5, NOW())
ON DUPLICATE KEY UPDATE category_name = VALUES(category_name);

-- Create upload directories (MySQL can't create directories, you need to do this manually or via PHP)
-- Make sure these directories exist:
-- /uploads/magazines/
-- /uploads/magazines/covers/
-- /uploads/images/

SELECT 'Database initialization complete!' AS message;
SELECT 'Make sure to create the following directories:' AS reminder;
SELECT '  - /uploads/magazines/' AS dir1;
SELECT '  - /uploads/magazines/covers/' AS dir2;
SELECT '  - /uploads/images/' AS dir3;
