<?php

class LearningPathController {
    protected $model;

    public function __construct($pdo) {
        $this->model = new LearningPathModel($pdo);
    }

    public function index() {
        return $this->model->getAllPaths();
    }

    public function show($slug) {
        $path = $this->model->getPathBySlug($slug);
        if (!$path) {
            return null;
        }
        $steps = $this->model->getStepsForPath($path['id']);
        return ['path' => $path, 'steps' => $steps];
    }
}
