<?php

class LearningPathModel {
    protected $pdo;

    public function __construct($pdo) {
        $this->pdo = $pdo;
    }

    public function getAllPaths() {
        $stmt = $this->pdo->query("SELECT * FROM learning_paths ORDER BY id ASC");
        return $stmt->fetchAll();
    }

    public function getPathBySlug($slug) {
        $stmt = $this->pdo->prepare("SELECT * FROM learning_paths WHERE slug = :slug LIMIT 1");
        $stmt->execute(['slug' => $slug]);
        return $stmt->fetch();
    }

    public function getStepsForPath($pathId) {
        $stmt = $this->pdo->prepare("SELECT * FROM learning_steps WHERE path_id = :path_id ORDER BY day_number ASC");
        $stmt->execute(['path_id' => $pathId]);
        return $stmt->fetchAll();
    }
}
