<?php

class StatsModel {
    protected $pdo;

    public function __construct($pdo) {
        $this->pdo = $pdo;
    }

    public function getUserStats($userId) {
        $stmt = $this->pdo->prepare("SELECT * FROM user_stats WHERE user_id = :user_id LIMIT 1");
        $stmt->execute(['user_id' => $userId]);
        $stats = $stmt->fetch();

        if (!$stats) {
            // Return default values if no stats found
            return [
                'total_eye_exercises_minutes' => 0,
                'total_focus_minutes' => 0,
                'total_breathing_sessions' => 0,
                'last_activity_at' => null
            ];
        }

        return $stats;
    }
    
    public function initStats($userId) {
        // Create initial stats record
        $insertSql = $this->isSqlite()
            ? "INSERT OR IGNORE INTO user_stats (user_id) VALUES (:user_id)"
            : "INSERT IGNORE INTO user_stats (user_id) VALUES (:user_id)";

        $stmt = $this->pdo->prepare($insertSql);
        $stmt->execute(['user_id' => $userId]);
    }

    public function incrementEyeMinutes($userId, $minutes) {
        $stmt = $this->pdo->prepare("UPDATE user_stats SET total_eye_exercises_minutes = total_eye_exercises_minutes + :minutes, last_activity_at = CURRENT_TIMESTAMP WHERE user_id = :user_id");
        $stmt->execute(['minutes' => $minutes, 'user_id' => $userId]);
    }

    public function incrementFocusMinutes($userId, $minutes) {
        $stmt = $this->pdo->prepare("UPDATE user_stats SET total_focus_minutes = total_focus_minutes + :minutes, last_activity_at = CURRENT_TIMESTAMP WHERE user_id = :user_id");
        $stmt->execute(['minutes' => $minutes, 'user_id' => $userId]);
    }

    public function incrementBreathingSessions($userId) {
        $stmt = $this->pdo->prepare("UPDATE user_stats SET total_breathing_sessions = total_breathing_sessions + 1, last_activity_at = CURRENT_TIMESTAMP WHERE user_id = :user_id");
        $stmt->execute(['user_id' => $userId]);
    }

    private function isSqlite(): bool {
        return $this->pdo->getAttribute(PDO::ATTR_DRIVER_NAME) === 'sqlite';
    }
}
