<?php

class UserModel {
    protected $pdo;

    public function __construct($pdo) {
        $this->pdo = $pdo;
    }

    public function findByEmail($email) {
        $stmt = $this->pdo->prepare("SELECT * FROM users WHERE email = :email LIMIT 1");
        $stmt->execute(['email' => $email]);
        return $stmt->fetch();
    }

    public function findById($id) {
        $stmt = $this->pdo->prepare("SELECT * FROM users WHERE id = :id LIMIT 1");
        $stmt->execute(['id' => $id]);
        return $stmt->fetch();
    }

    public function createUser($email, $passwordHash, $name) {
        $stmt = $this->pdo->prepare("INSERT INTO users (email, password_hash, name, created_at) VALUES (:email, :password_hash, :name, CURRENT_TIMESTAMP)");
        $stmt->execute([
            'email' => $email,
            'password_hash' => $passwordHash,
            'name' => $name
        ]);
        return $this->pdo->lastInsertId();
    }
}
