<?php
/**
 * Script to create necessary upload directories
 * Run this once to set up the file structure
 */

$directories = [
    __DIR__ . '/../uploads',
    __DIR__ . '/../uploads/magazines',
    __DIR__ . '/../uploads/magazines/covers',
    __DIR__ . '/../uploads/images'
];

echo "Creating upload directories...\n\n";

foreach ($directories as $dir) {
    if (!is_dir($dir)) {
        if (mkdir($dir, 0755, true)) {
            echo "✓ Created: $dir\n";
        } else {
            echo "✗ Failed to create: $dir\n";
        }
    } else {
        echo "○ Already exists: $dir\n";
    }
}

// Create .htaccess to protect uploads directory
$htaccessContent = "# Prevent directory listing\nOptions -Indexes\n\n# Allow only specific file types\n<FilesMatch \"\\.(pdf|jpg|jpeg|png|gif|webp)$\">\n    Allow from all\n</FilesMatch>\n";

$htaccessPath = __DIR__ . '/../uploads/.htaccess';
if (!file_exists($htaccessPath)) {
    if (file_put_contents($htaccessPath, $htaccessContent)) {
        echo "\n✓ Created .htaccess protection in uploads directory\n";
    }
} else {
    echo "\n○ .htaccess already exists in uploads directory\n";
}

echo "\n✓ Setup complete!\n";
echo "\nNext steps:\n";
echo "1. Run database/init_settings.sql to populate default settings\n";
echo "2. Access /admin/settings-seo.php to configure your site\n";
echo "3. Access /admin/subscriptions.php to manage subscription plans\n";
