<?php
require_once __DIR__ . '/../../includes/bootstrap.php';

requireAdmin();

$pdo = getPDO();

// Get all articles with their SEO data
$stmt = $pdo->query("
    SELECT 
        a.id,
        a.title,
        a.slug,
        aseo.meta_title,
        aseo.meta_description,
        aseo.og_image,
        aseo.created_at as seo_created_at,
        (SELECT COUNT(*) FROM content_category_article WHERE article_id = a.id) as category_count
    FROM articles a
    LEFT JOIN article_seo aseo ON a.id = aseo.article_id
    ORDER BY a.created_at DESC
");
$articles = $stmt->fetchAll(PDO::FETCH_ASSOC);

$pageTitle = 'Articles SEO Management - Admin';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= e($pageTitle) ?></title>
    <link rel="stylesheet" href="<?= base_url('assets/css/style.css') ?>">
    <style>
        .admin-container { max-width: 1400px; margin: 40px auto; padding: 20px; }
        .admin-nav { background: #f8f9fa; padding: 15px; border-radius: 8px; margin-bottom: 30px; }
        .admin-nav a { margin-right: 15px; padding: 8px 15px; background: #007bff; color: white; text-decoration: none; border-radius: 5px; display: inline-block; margin-bottom: 5px; }
        .admin-nav a:hover { background: #0056b3; }
        .admin-nav a.active { background: #28a745; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { padding: 12px; text-align: left; border-bottom: 1px solid #ddd; }
        th { background: #f8f9fa; font-weight: bold; }
        .badge { padding: 4px 8px; border-radius: 3px; font-size: 11px; font-weight: bold; }
        .badge-complete { background: #28a745; color: white; }
        .badge-incomplete { background: #dc3545; color: white; }
        .badge-partial { background: #ffc107; color: #333; }
        .btn { padding: 8px 15px; background: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer; text-decoration: none; display: inline-block; font-size: 13px; }
        .btn:hover { background: #0056b3; }
        .btn-sm { padding: 5px 10px; font-size: 12px; }
        .alert { padding: 15px; border-radius: 5px; margin-bottom: 20px; }
        .alert-info { background: #d1ecf1; color: #0c5460; }
        .stats { background: #f8f9fa; padding: 20px; border-radius: 8px; margin-bottom: 30px; }
        .stats-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 20px; }
        .stat-item { text-align: center; }
        .stat-item h3 { margin: 0; font-size: 32px; color: #007bff; }
        .stat-item p { margin: 5px 0 0; color: #666; }
    </style>
</head>
<body>
    <div class="admin-container">
        <h1>Admin Panel - Articles SEO Management</h1>
        
        <?php include 'partials/admin-nav.php'; ?>
        
        <?php
        $completeCount = 0;
        $partialCount = 0;
        $incompleteCount = 0;
        
        foreach ($articles as $article) {
            if (!empty($article['meta_title']) && !empty($article['meta_description'])) {
                $completeCount++;
            } elseif (!empty($article['meta_title']) || !empty($article['meta_description'])) {
                $partialCount++;
            } else {
                $incompleteCount++;
            }
        }
        ?>
        
        <div class="stats">
            <h2>SEO Status Overview</h2>
            <div class="stats-grid">
                <div class="stat-item">
                    <h3><?= $completeCount ?></h3>
                    <p>Complete SEO</p>
                </div>
                <div class="stat-item">
                    <h3><?= $partialCount ?></h3>
                    <p>Partial SEO</p>
                </div>
                <div class="stat-item">
                    <h3><?= $incompleteCount ?></h3>
                    <p>No SEO</p>
                </div>
            </div>
        </div>
        
        <div class="alert alert-info">
            <strong>📝 Note:</strong> Use the existing article admin page to edit full article SEO metadata. 
            This page provides an overview of which articles need SEO attention.
            Go to <a href="<?= base_url('admin/articles.php') ?>">Articles Admin</a> to edit individual articles.
        </div>
        
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Title</th>
                    <th>SEO Status</th>
                    <th>Meta Title</th>
                    <th>Meta Description</th>
                    <th>Categories</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($articles as $article): ?>
                <?php
                $hasTitle = !empty($article['meta_title']);
                $hasDesc = !empty($article['meta_description']);
                
                if ($hasTitle && $hasDesc) {
                    $status = 'complete';
                    $statusLabel = 'Complete';
                } elseif ($hasTitle || $hasDesc) {
                    $status = 'partial';
                    $statusLabel = 'Partial';
                } else {
                    $status = 'incomplete';
                    $statusLabel = 'Missing';
                }
                ?>
                <tr>
                    <td><?= e($article['id']) ?></td>
                    <td>
                        <strong><?= e($article['title']) ?></strong><br>
                        <small style="color: #666;">Slug: <?= e($article['slug']) ?></small>
                    </td>
                    <td>
                        <span class="badge badge-<?= $status ?>">
                            <?= $statusLabel ?>
                        </span>
                    </td>
                    <td>
                        <?php if ($hasTitle): ?>
                            <span style="color: #28a745;">✓</span> Set (<?= strlen($article['meta_title']) ?> chars)
                        <?php else: ?>
                            <span style="color: #dc3545;">✗</span> Not set
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if ($hasDesc): ?>
                            <span style="color: #28a745;">✓</span> Set (<?= strlen($article['meta_description']) ?> chars)
                        <?php else: ?>
                            <span style="color: #dc3545;">✗</span> Not set
                        <?php endif; ?>
                    </td>
                    <td><?= e($article['category_count']) ?> categories</td>
                    <td>
                        <a href="<?= base_url('admin/articles.php') ?>" class="btn btn-sm">
                            Edit Article & SEO
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</body>
</html>
