<?php
require_once __DIR__ . '/../../includes/bootstrap.php';

requireAdmin();

$magazineController = new MagazineController(getPDO());
$categories = $magazineController->getAllCategories();

// Handle actions
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    verify_csrf();
    
    if ($_POST['action'] === 'delete') {
        $id = $_POST['id'] ?? null;
        if ($id && $magazineController->deleteMagazine($id)) {
            flash('flash_message', 'Magazine deleted successfully!', 'success');
        } else {
            flash('flash_message', 'Error deleting magazine.', 'danger');
        }
    }
    
    redirect(base_url('admin/magazines.php'));
}

// Get all magazines
$filterCategoryId = $_GET['category'] ?? null;
$filters = [];
if ($filterCategoryId) {
    $filters['category_id'] = $filterCategoryId;
}
$magazines = $magazineController->getAllMagazines($filters);

$pageTitle = 'Magazines - Admin';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= e($pageTitle) ?></title>
    <link rel="stylesheet" href="<?= base_url('assets/css/style.css') ?>">
    <style>
        .admin-container { max-width: 1400px; margin: 40px auto; padding: 20px; }
        .admin-nav { background: #f8f9fa; padding: 15px; border-radius: 8px; margin-bottom: 30px; }
        .admin-nav a { margin-right: 15px; padding: 8px 15px; background: #007bff; color: white; text-decoration: none; border-radius: 5px; display: inline-block; margin-bottom: 5px; }
        .admin-nav a:hover { background: #0056b3; }
        .admin-nav a.active { background: #28a745; }
        .btn { padding: 10px 20px; background: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer; text-decoration: none; display: inline-block; }
        .btn:hover { background: #0056b3; }
        .btn-danger { background: #dc3545; }
        .btn-danger:hover { background: #c82333; }
        .btn-sm { padding: 5px 10px; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { padding: 12px; text-align: left; border-bottom: 1px solid #ddd; }
        th { background: #f8f9fa; font-weight: bold; }
        .alert { padding: 15px; border-radius: 5px; margin-bottom: 20px; }
        .alert-success { background: #d4edda; color: #155724; }
        .alert-danger { background: #f8d7da; color: #721c24; }
        .badge { padding: 4px 8px; border-radius: 3px; font-size: 11px; font-weight: bold; }
        .badge-pro { background: #ffd700; color: #333; }
        .badge-free { background: #28a745; color: white; }
        .badge-draft { background: #6c757d; color: white; }
        .filter-bar { margin-bottom: 20px; padding: 15px; background: #f8f9fa; border-radius: 5px; }
        .filter-bar select { padding: 8px; border-radius: 5px; border: 1px solid #ddd; }
    </style>
</head>
<body>
    <div class="admin-container">
        <h1>Admin Panel - Magazines</h1>
        
        <?php include 'partials/admin-nav.php'; ?>
        
        <?php flash('flash_message'); ?>
        
        <div style="margin-bottom: 20px;">
            <a href="<?= base_url('admin/magazines-edit.php') ?>" class="btn">+ Upload New Magazine</a>
        </div>
        
        <div class="filter-bar">
            <form method="GET">
                <label>Filter by Category:</label>
                <select name="category" onchange="this.form.submit()">
                    <option value="">All Categories</option>
                    <?php foreach ($categories as $cat): ?>
                        <option value="<?= e($cat['id']) ?>" <?= $filterCategoryId == $cat['id'] ? 'selected' : '' ?>>
                            <?= e($cat['category_name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </form>
        </div>
        
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Title</th>
                    <th>Issue</th>
                    <th>Year</th>
                    <th>Month</th>
                    <th>Status</th>
                    <th>Downloads</th>
                    <th>File Size</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($magazines)): ?>
                    <tr>
                        <td colspan="9" style="text-align: center; padding: 40px;">
                            No magazines found. <a href="<?= base_url('admin/magazines-edit.php') ?>">Upload your first magazine</a>
                        </td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($magazines as $mag): ?>
                    <tr>
                        <td><?= e($mag['id']) ?></td>
                        <td><?= e($mag['title']) ?></td>
                        <td><?= e($mag['issue_number']) ?></td>
                        <td><?= e($mag['year']) ?></td>
                        <td><?= e($mag['month']) ?></td>
                        <td>
                            <?php if (!$mag['is_public']): ?>
                                <span class="badge badge-draft">Draft</span>
                            <?php elseif ($mag['is_pro_only']): ?>
                                <span class="badge badge-pro">PRO Only</span>
                            <?php else: ?>
                                <span class="badge badge-free">Free</span>
                            <?php endif; ?>
                        </td>
                        <td><?= e($mag['download_count'] ?? 0) ?></td>
                        <td><?= $mag['file_size'] ? formatFileSize($mag['file_size']) : 'N/A' ?></td>
                        <td>
                            <a href="<?= base_url('admin/magazines-edit.php?id=' . $mag['id']) ?>" class="btn btn-sm">Edit</a>
                            <form method="POST" style="display:inline;" onsubmit="return confirm('Delete this magazine and its files?');">
                                <?= csrf_field() ?>
                                <input type="hidden" name="action" value="delete">
                                <input type="hidden" name="id" value="<?= e($mag['id']) ?>">
                                <button type="submit" class="btn btn-sm btn-danger">Delete</button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</body>
</html>
