<?php
require_once __DIR__ . '/../../includes/bootstrap.php';

requireAdmin();

$quoteModel = new QuoteModel(getPDO());
$action = $_GET['action'] ?? 'list';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    verify_csrf();
    
    if ($action === 'create') {
        $text = trim($_POST['text'] ?? '');
        $author = trim($_POST['author'] ?? '');

        if ($text === '' || strlen($text) > 1000) {
            flash('error', 'Quote text is required and must be under 1000 characters.');
            redirect('quotes.php?action=create');
        }

        if (strlen($author) > 190) {
            flash('error', 'Author must be under 190 characters.');
            redirect('quotes.php?action=create');
        }

        $quoteModel->createQuote($text, $author);
        flash('success', 'Quote added.');
        redirect('quotes.php');
    } elseif ($action === 'delete') {
        $id = isset($_POST['id']) ? (int) $_POST['id'] : 0;
        if ($id > 0) {
            $quoteModel->deleteQuote($id);
            flash('success', 'Quote deleted.');
        } else {
            flash('error', 'Invalid quote id.');
        }
        redirect('quotes.php');
    }
}

include __DIR__ . '/../../templates/layout/header.php';
?>

<h2>Manage Quotes</h2>
<div class="row">
    <div class="col-md-6">
        <h3>Add New Quote</h3>
        <form method="POST" action="quotes.php?action=create">
            <?= csrf_field() ?>
            <div class="form-group">
                <label>Quote Text</label>
                <textarea name="text" class="form-control" required></textarea>
            </div>
            <div class="form-group">
                <label>Author</label>
                <input type="text" name="author" class="form-control">
            </div>
            <button type="submit" class="btn btn-primary">Add Quote</button>
        </form>
    </div>
</div>

<hr>

<h3>Existing Quotes</h3>
<?php $quotes = $quoteModel->getAllQuotes(); ?>
<table border="1" cellpadding="10" style="width:100%; border-collapse: collapse;">
    <thead>
        <tr>
            <th>ID</th>
            <th>Quote</th>
            <th>Author</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($quotes as $quote): ?>
            <tr>
                <td><?= $quote['id'] ?></td>
                <td><?= e($quote['text']) ?></td>
                <td><?= e($quote['author']) ?></td>
                <td>
                    <form action="quotes.php?action=delete" method="POST" style="display:inline;" onsubmit="return confirm('Are you sure?');">
                        <?= csrf_field() ?>
                        <input type="hidden" name="id" value="<?= $quote['id'] ?>">
                        <button type="submit">Delete</button>
                    </form>
                </td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<?php include __DIR__ . '/../templates/layout/footer.php'; ?>
