<?php
require_once __DIR__ . '/../../includes/bootstrap.php';

requireAdmin();

$settingsController = new SettingsController(getPDO());

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    verify_csrf();
    
    $settings = [
        'smtp_host' => $_POST['smtp_host'] ?? '',
        'smtp_port' => $_POST['smtp_port'] ?? '587',
        'smtp_username' => $_POST['smtp_username'] ?? '',
        'smtp_password' => $_POST['smtp_password'] ?? '',
        'newsletter_from_name' => $_POST['newsletter_from_name'] ?? '',
        'newsletter_from_email' => $_POST['newsletter_from_email'] ?? '',
        'newsletter_enabled' => $_POST['newsletter_enabled'] ?? '0'
    ];
    
    if ($settingsController->updateSettings($settings)) {
        flash('flash_message', 'Email settings updated successfully!', 'success');
    } else {
        flash('flash_message', 'Error updating email settings.', 'danger');
    }
    
    redirect(base_url('admin/settings-email.php'));
}

$pageTitle = 'Email Settings - Admin';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= e($pageTitle) ?></title>
    <link rel="stylesheet" href="<?= base_url('assets/css/style.css') ?>">
    <style>
        .admin-container { max-width: 1200px; margin: 40px auto; padding: 20px; }
        .admin-nav { background: #f8f9fa; padding: 15px; border-radius: 8px; margin-bottom: 30px; }
        .admin-nav a { margin-right: 15px; padding: 8px 15px; background: #007bff; color: white; text-decoration: none; border-radius: 5px; display: inline-block; margin-bottom: 5px; }
        .admin-nav a:hover { background: #0056b3; }
        .admin-nav a.active { background: #28a745; }
        .form-group { margin-bottom: 20px; }
        .form-group label { display: block; font-weight: bold; margin-bottom: 5px; }
        .form-group input { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 5px; font-size: 14px; }
        .form-group small { display: block; color: #666; margin-top: 5px; }
        .checkbox-group { margin-bottom: 20px; }
        .checkbox-group input { width: auto; margin-right: 10px; }
        .btn { padding: 12px 24px; background: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer; font-size: 16px; }
        .btn:hover { background: #0056b3; }
        .alert { padding: 15px; border-radius: 5px; margin-bottom: 20px; }
        .alert-success { background: #d4edda; color: #155724; }
        .alert-danger { background: #f8d7da; color: #721c24; }
        .section-divider { border-top: 2px solid #ddd; margin: 30px 0; padding-top: 20px; }
    </style>
</head>
<body>
    <div class="admin-container">
        <h1>Admin Panel - Email Settings</h1>
        
        <?php include 'partials/admin-nav.php'; ?>
        
        <?php flash('flash_message'); ?>
        
        <div class="settings-form">
            <form method="POST">
                <?= csrf_field() ?>
                
                <div class="section-divider">
                    <h2>SMTP Configuration</h2>
                    <p>Configure email server settings for sending transactional emails and newsletters.</p>
                </div>
                
                <div class="form-group">
                    <label for="smtp_host">SMTP Host</label>
                    <input type="text" id="smtp_host" name="smtp_host" 
                           value="<?= e(getSetting('smtp_host')) ?>" 
                           placeholder="smtp.gmail.com">
                    <small>Example: smtp.gmail.com, smtp.sendgrid.net</small>
                </div>
                
                <div class="form-group">
                    <label for="smtp_port">SMTP Port</label>
                    <input type="number" id="smtp_port" name="smtp_port" 
                           value="<?= e(getSetting('smtp_port')) ?>" 
                           placeholder="587">
                    <small>Common ports: 587 (TLS), 465 (SSL), 25 (non-encrypted)</small>
                </div>
                
                <div class="form-group">
                    <label for="smtp_username">SMTP Username</label>
                    <input type="text" id="smtp_username" name="smtp_username" 
                           value="<?= e(getSetting('smtp_username')) ?>">
                    <small>Usually your email address</small>
                </div>
                
                <div class="form-group">
                    <label for="smtp_password">SMTP Password</label>
                    <input type="password" id="smtp_password" name="smtp_password" 
                           value="<?= e(getSetting('smtp_password')) ?>">
                    <small>Your email password or app-specific password</small>
                </div>
                
                <div class="section-divider">
                    <h2>Newsletter Settings</h2>
                </div>
                
                <div class="checkbox-group">
                    <label>
                        <input type="checkbox" name="newsletter_enabled" value="1" 
                               <?= getSetting('newsletter_enabled') === '1' ? 'checked' : '' ?>>
                        Enable Newsletter Functionality
                    </label>
                </div>
                
                <div class="form-group">
                    <label for="newsletter_from_name">Newsletter Sender Name</label>
                    <input type="text" id="newsletter_from_name" name="newsletter_from_name" 
                           value="<?= e(getSetting('newsletter_from_name')) ?>" 
                           placeholder="Enterlife Team">
                </div>
                
                <div class="form-group">
                    <label for="newsletter_from_email">Newsletter Sender Email</label>
                    <input type="email" id="newsletter_from_email" name="newsletter_from_email" 
                           value="<?= e(getSetting('newsletter_from_email')) ?>" 
                           placeholder="newsletter@enterlife.com">
                </div>
                
                <button type="submit" class="btn">Save Email Settings</button>
            </form>
        </div>
    </div>
</body>
</html>
