<?php
require_once __DIR__ . '/../../includes/bootstrap.php';

requireAdmin();

$settingsController = new SettingsController(getPDO());

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    verify_csrf();
    
    $settings = [
        'tracking_enabled' => $_POST['tracking_enabled'] ?? '0',
        'ga4_measurement_id' => $_POST['ga4_measurement_id'] ?? '',
        'gtm_container_id' => $_POST['gtm_container_id'] ?? '',
        'adsense_client_id' => $_POST['adsense_client_id'] ?? '',
        'adsense_code_head' => $_POST['adsense_code_head'] ?? '',
        'adsense_code_body' => $_POST['adsense_code_body'] ?? '',
        'facebook_pixel_id' => $_POST['facebook_pixel_id'] ?? '',
        'custom_head_scripts' => $_POST['custom_head_scripts'] ?? '',
        'custom_body_scripts' => $_POST['custom_body_scripts'] ?? ''
    ];
    
    if ($settingsController->updateSettings($settings)) {
        flash('flash_message', 'Marketing settings updated successfully!', 'success');
    } else {
        flash('flash_message', 'Error updating marketing settings.', 'danger');
    }
    
    redirect(base_url('admin/settings-marketing.php'));
}

$pageTitle = 'Marketing & Tracking Settings - Admin';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= e($pageTitle) ?></title>
    <link rel="stylesheet" href="<?= base_url('assets/css/style.css') ?>">
    <style>
        .admin-container { max-width: 1200px; margin: 40px auto; padding: 20px; }
        .admin-nav { background: #f8f9fa; padding: 15px; border-radius: 8px; margin-bottom: 30px; }
        .admin-nav a { margin-right: 15px; padding: 8px 15px; background: #007bff; color: white; text-decoration: none; border-radius: 5px; display: inline-block; margin-bottom: 5px; }
        .admin-nav a:hover { background: #0056b3; }
        .admin-nav a.active { background: #28a745; }
        .form-group { margin-bottom: 20px; }
        .form-group label { display: block; font-weight: bold; margin-bottom: 5px; }
        .form-group input, .form-group textarea, .form-group select { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 5px; font-size: 14px; }
        .form-group textarea { min-height: 100px; font-family: monospace; }
        .form-group small { display: block; color: #666; margin-top: 5px; }
        .checkbox-group { margin-top: 10px; }
        .checkbox-group input { width: auto; margin-right: 10px; }
        .btn { padding: 12px 24px; background: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer; font-size: 16px; }
        .btn:hover { background: #0056b3; }
        .alert { padding: 15px; border-radius: 5px; margin-bottom: 20px; }
        .alert-success { background: #d4edda; color: #155724; }
        .alert-danger { background: #f8d7da; color: #721c24; }
        .section-divider { border-top: 2px solid #ddd; margin: 30px 0; padding-top: 20px; }
    </style>
</head>
<body>
    <div class="admin-container">
        <h1>Admin Panel - Marketing & Tracking Settings</h1>
        
        <?php include 'partials/admin-nav.php'; ?>
        
        <?php flash('flash_message'); ?>
        
        <div class="settings-form">
            <form method="POST">
                <?= csrf_field() ?>
                
                <div class="form-group checkbox-group">
                    <label>
                        <input type="checkbox" name="tracking_enabled" value="1" 
                               <?= getSetting('tracking_enabled') === '1' ? 'checked' : '' ?>>
                        Enable Tracking & Analytics (global on/off switch)
                    </label>
                </div>
                
                <div class="section-divider">
                    <h2>Google Analytics 4 (GA4)</h2>
                </div>
                
                <div class="form-group">
                    <label for="ga4_measurement_id">GA4 Measurement ID</label>
                    <input type="text" id="ga4_measurement_id" name="ga4_measurement_id" 
                           value="<?= e(getSetting('ga4_measurement_id')) ?>" 
                           placeholder="G-XXXXXXXXXX">
                    <small>Example: G-XXXXXXXXXX</small>
                </div>
                
                <div class="section-divider">
                    <h2>Google Tag Manager (GTM)</h2>
                </div>
                
                <div class="form-group">
                    <label for="gtm_container_id">GTM Container ID</label>
                    <input type="text" id="gtm_container_id" name="gtm_container_id" 
                           value="<?= e(getSetting('gtm_container_id')) ?>" 
                           placeholder="GTM-XXXXXXX">
                    <small>Example: GTM-XXXXXXX</small>
                </div>
                
                <div class="section-divider">
                    <h2>Google Adsense</h2>
                </div>
                
                <div class="form-group">
                    <label for="adsense_client_id">Adsense Client ID</label>
                    <input type="text" id="adsense_client_id" name="adsense_client_id" 
                           value="<?= e(getSetting('adsense_client_id')) ?>" 
                           placeholder="ca-pub-XXXXXXXXXXXXXXXX">
                    <small>Example: ca-pub-XXXXXXXXXXXXXXXX</small>
                </div>
                
                <div class="form-group">
                    <label for="adsense_code_head">Adsense Head Code</label>
                    <textarea id="adsense_code_head" name="adsense_code_head"><?= e(getSetting('adsense_code_head')) ?></textarea>
                    <small>Paste full Adsense script tag for &lt;head&gt;</small>
                </div>
                
                <div class="form-group">
                    <label for="adsense_code_body">Adsense Body Code</label>
                    <textarea id="adsense_code_body" name="adsense_code_body"><?= e(getSetting('adsense_code_body')) ?></textarea>
                    <small>Paste Adsense ad units for &lt;body&gt;</small>
                </div>
                
                <div class="section-divider">
                    <h2>Facebook Pixel</h2>
                </div>
                
                <div class="form-group">
                    <label for="facebook_pixel_id">Facebook Pixel ID</label>
                    <input type="text" id="facebook_pixel_id" name="facebook_pixel_id" 
                           value="<?= e(getSetting('facebook_pixel_id')) ?>" 
                           placeholder="XXXXXXXXXXXXXXXX">
                    <small>Example: XXXXXXXXXXXXXXXX (numbers only)</small>
                </div>
                
                <div class="section-divider">
                    <h2>Custom Scripts</h2>
                </div>
                
                <div class="form-group">
                    <label for="custom_head_scripts">Custom Head Scripts</label>
                    <textarea id="custom_head_scripts" name="custom_head_scripts"><?= e(getSetting('custom_head_scripts')) ?></textarea>
                    <small>Additional scripts to inject in &lt;head&gt; (e.g., other analytics, heatmaps)</small>
                </div>
                
                <div class="form-group">
                    <label for="custom_body_scripts">Custom Body Scripts</label>
                    <textarea id="custom_body_scripts" name="custom_body_scripts"><?= e(getSetting('custom_body_scripts')) ?></textarea>
                    <small>Additional scripts to inject before &lt;/body&gt;</small>
                </div>
                
                <button type="submit" class="btn">Save Marketing Settings</button>
            </form>
        </div>
    </div>
</body>
</html>
