<?php
require_once __DIR__ . '/../../includes/bootstrap.php';

requireAdmin();

$settingsController = new SettingsController(getPDO());

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    verify_csrf();
    
    $settings = [
        'default_meta_title' => $_POST['default_meta_title'] ?? '',
        'default_meta_description' => $_POST['default_meta_description'] ?? '',
        'default_og_image' => $_POST['default_og_image'] ?? '',
        'default_twitter_card_type' => $_POST['default_twitter_card_type'] ?? 'summary_large_image',
        'site_schema_org_type' => $_POST['site_schema_org_type'] ?? 'WebSite',
        'robots_txt_content' => $_POST['robots_txt_content'] ?? ''
    ];
    
    if ($settingsController->updateSettings($settings)) {
        flash('flash_message', 'SEO settings updated successfully!', 'success');
    } else {
        flash('flash_message', 'Error updating SEO settings.', 'danger');
    }
    
    redirect(base_url('admin/settings-seo.php'));
}

// Load current settings
$seoSettings = $settingsController->getSettingsByCategory('default_');
$pageTitle = 'SEO Settings - Admin';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= e($pageTitle) ?></title>
    <link rel="stylesheet" href="<?= base_url('assets/css/style.css') ?>">
    <style>
        .admin-container {
            max-width: 1200px;
            margin: 40px auto;
            padding: 20px;
        }
        .admin-nav {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 30px;
        }
        .admin-nav a {
            margin-right: 15px;
            padding: 8px 15px;
            background: #007bff;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            display: inline-block;
            margin-bottom: 5px;
        }
        .admin-nav a:hover {
            background: #0056b3;
        }
        .admin-nav a.active {
            background: #28a745;
        }
        .form-group {
            margin-bottom: 20px;
        }
        .form-group label {
            display: block;
            font-weight: bold;
            margin-bottom: 5px;
        }
        .form-group input,
        .form-group textarea,
        .form-group select {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 14px;
        }
        .form-group textarea {
            min-height: 100px;
            font-family: monospace;
        }
        .form-group small {
            display: block;
            color: #666;
            margin-top: 5px;
        }
        .btn {
            padding: 12px 24px;
            background: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
        }
        .btn:hover {
            background: #0056b3;
        }
        .alert {
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        .alert-success {
            background: #d4edda;
            color: #155724;
        }
        .alert-danger {
            background: #f8d7da;
            color: #721c24;
        }
    </style>
</head>
<body>
    <div class="admin-container">
        <h1>Admin Panel - SEO Settings</h1>
        
        <?php include 'partials/admin-nav.php'; ?>
        
        <?php flash('flash_message'); ?>
        
        <div class="settings-form">
            <h2>Default SEO Metadata</h2>
            <p>These settings will be used as fallback when individual pages don't have their own SEO metadata.</p>
            
            <form method="POST">
                <?= csrf_field() ?>
                
                <div class="form-group">
                    <label for="default_meta_title">Default Meta Title</label>
                    <input type="text" id="default_meta_title" name="default_meta_title" 
                           value="<?= e(getSetting('default_meta_title')) ?>" 
                           maxlength="60">
                    <small>Recommended: 50-60 characters</small>
                </div>
                
                <div class="form-group">
                    <label for="default_meta_description">Default Meta Description</label>
                    <textarea id="default_meta_description" name="default_meta_description" 
                              maxlength="160"><?= e(getSetting('default_meta_description')) ?></textarea>
                    <small>Recommended: 150-160 characters</small>
                </div>
                
                <div class="form-group">
                    <label for="default_og_image">Default Open Graph Image</label>
                    <input type="text" id="default_og_image" name="default_og_image" 
                           value="<?= e(getSetting('default_og_image')) ?>" 
                           placeholder="/assets/img/og-default.jpg">
                    <small>Full URL or path to default social sharing image (recommended: 1200x630px)</small>
                </div>
                
                <div class="form-group">
                    <label for="default_twitter_card_type">Twitter Card Type</label>
                    <select id="default_twitter_card_type" name="default_twitter_card_type">
                        <option value="summary" <?= getSetting('default_twitter_card_type') === 'summary' ? 'selected' : '' ?>>Summary</option>
                        <option value="summary_large_image" <?= getSetting('default_twitter_card_type') === 'summary_large_image' ? 'selected' : '' ?>>Summary Large Image</option>
                    </select>
                </div>
                
                <div class="form-group">
                    <label for="site_schema_org_type">Schema.org Type</label>
                    <select id="site_schema_org_type" name="site_schema_org_type">
                        <option value="WebSite" <?= getSetting('site_schema_org_type') === 'WebSite' ? 'selected' : '' ?>>WebSite</option>
                        <option value="Organization" <?= getSetting('site_schema_org_type') === 'Organization' ? 'selected' : '' ?>>Organization</option>
                        <option value="HealthAndBeautyBusiness" <?= getSetting('site_schema_org_type') === 'HealthAndBeautyBusiness' ? 'selected' : '' ?>>Health & Beauty Business</option>
                    </select>
                    <small>Schema.org structured data type for search engines</small>
                </div>
                
                <div class="form-group">
                    <label for="robots_txt_content">Robots.txt Directives</label>
                    <textarea id="robots_txt_content" name="robots_txt_content"><?= e(getSetting('robots_txt_content')) ?></textarea>
                    <small>Configure search engine crawler behavior</small>
                </div>
                
                <button type="submit" class="btn">Save SEO Settings</button>
            </form>
        </div>
    </div>
</body>
</html>
