<?php
require_once __DIR__ . '/../../../includes/bootstrap.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    $minutes = $data['minutes'] ?? 0;
    
    if ($minutes > 0) {
        $statsModel = new StatsModel(getPDO());
        $statsModel->incrementFocusMinutes($_SESSION['user_id'], $minutes);
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'error' => 'Invalid duration']);
    }
}
