<?php
require_once __DIR__ . '/../includes/bootstrap.php';

requireLogin();

$challengeModel = new ChallengeModel(getPDO());
$user = currentUser();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['complete_challenge'])) {
    verify_csrf();
    $assignmentId = $_POST['assignment_id'];
    $challengeModel->completeChallenge($user['id'], $assignmentId);
    flash('success', 'Challenge completed! Keep it up.');
    redirect('challenges.php');
}

$dailyChallenge = $challengeModel->getDailyChallenge($user['id']);
$streak = $challengeModel->getStreak($user['id']);

include __DIR__ . '/../templates/layout/header.php';
include __DIR__ . '/../templates/challenges/today.php';
include __DIR__ . '/../templates/layout/footer.php';
