<?php
require_once __DIR__ . '/../includes/bootstrap.php';
require_once __DIR__ . '/../includes/models/LearningPathModel.php';
require_once __DIR__ . '/../includes/controllers/LearningPathController.php';

$controller = new LearningPathController(getPDO());

if (isset($_GET['slug'])) {
    $data = $controller->show($_GET['slug']);
    
    if (!$data) {
        http_response_code(404);
        die("Learning Path not found");
    }
    
    $path = $data['path'];
    $steps = $data['steps'];
    
    include __DIR__ . '/../templates/layout/header.php';
    include __DIR__ . '/../templates/learning_paths/detail.php';
    include __DIR__ . '/../templates/layout/footer.php';
} else {
    $paths = $controller->index();
    
    include __DIR__ . '/../templates/layout/header.php';
    include __DIR__ . '/../templates/learning_paths/list.php';
    include __DIR__ . '/../templates/layout/footer.php';
}
