<?php
require_once __DIR__ . '/../includes/bootstrap.php';

if (isLoggedIn()) {
    redirect(base_url('dashboard.php'));
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    verify_csrf();
    
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';
    
    $userModel = new UserModel(getPDO());
    $user = $userModel->findByEmail($email);
    
    if ($user && password_verify($password, $user['password_hash'])) {
        loginUser($user);
        flash('success', 'Welcome back!');
        redirect(base_url('dashboard.php'));
    } else {
        flash('error', 'Invalid credentials.');
    }
}

include __DIR__ . '/../templates/layout/header.php';
include __DIR__ . '/../templates/auth/login_form.php';
include __DIR__ . '/../templates/layout/footer.php';
