<h2>Dashboard</h2>
<p class="lead">Welcome back, <?= e($user['name']) ?>!</p>

<?php
$quoteModel = new QuoteModel(getPDO());
$quote = $quoteModel->getRandomQuote();
if ($quote):
?>
    <blockquote style="background: #f9f9f9; padding: 15px; border-left: 5px solid #ccc; margin: 20px 0;">
        <p style="font-size: 1.2em; font-style: italic;">"<?= e($quote['text']) ?>"</p>
        <footer style="margin-top: 10px;">— <?= e($quote['author'] ?: 'Unknown') ?></footer>
    </blockquote>
<?php endif; ?>

<div class="grid grid-cols-2 mb-4">
    <div class="card">
        <h3>Daily Challenge</h3>
        <p><strong><?= e($dailyChallenge['title']) ?></strong></p>
        <p><?= e($dailyChallenge['description']) ?></p>
        <?php if ($dailyChallenge['completed']): ?>
            <span class="text-success">Completed!</span>
        <?php else: ?>
            <a href="challenges.php" class="btn btn-sm btn-primary">View Challenge</a>
        <?php endif; ?>
    </div>
    <div class="card">
        <h3>Today's Mood</h3>
        <?php if ($todayMood): ?>
            <p>You feel <strong><?= $todayMood['mood_value'] ?>/5</strong>.</p>
        <?php else: ?>
            <p>How are you feeling?</p>
            <a href="mood.php" class="btn btn-sm btn-secondary">Log Mood</a>
        <?php endif; ?>
    </div>
</div>

<div class="card mb-4">
    <div style="display: flex; justify-content: space-between; align-items: center;">
        <div>
            <h3>Your Learning Journey</h3>
            <p>Start a structured path to improve your well-being.</p>
        </div>
        <a href="learning-paths.php" class="btn btn-primary">Explore Paths</a>
    </div>
</div>

<div class="stats-overview grid grid-cols-3 mb-4">
    <div class="card text-center">
        <h3>Focus Time</h3>
        <p class="stat-value"><?= $stats['total_focus_minutes'] ?> mins</p>
    </div>
    <div class="card text-center">
        <h3>Eye Exercises</h3>
        <p class="stat-value"><?= $stats['total_eye_exercises_minutes'] ?> mins</p>
    </div>
    <div class="card text-center">
        <h3>Breathing</h3>
        <p class="stat-value"><?= $stats['total_breathing_sessions'] ?> sessions</p>
    </div>
</div>

<hr>

<h3>Quick Actions</h3>
<div class="quick-actions mb-4">
    <a href="tools/focus-timer.php" class="btn btn-primary">Start Focus Timer</a>
    <a href="tools/eye-exercises.php" class="btn btn-secondary">Eye Exercises</a>
    <a href="tools/breathing.php" class="btn btn-success">Breathing</a>
</div>

<hr>

<h3>Recent Articles</h3>
<?php if (empty($recentArticles)): ?>
    <p>No articles yet.</p>
<?php else: ?>
    <ul>
        <?php foreach ($recentArticles as $article): ?>
            <li><a href="articles.php?slug=<?= e($article['slug']) ?>"><?= e($article['title']) ?></a></li>
        <?php endforeach; ?>
    </ul>
<?php endif; ?>

<style>
.stats-overview {
    display: flex;
    gap: 20px;
    margin-bottom: 30px;
}
.stat-card {
    background: #f4f4f4;
    padding: 20px;
    border-radius: 8px;
    flex: 1;
    text-align: center;
}
.stat-value {
    font-size: 2em;
    font-weight: bold;
    color: #007bff;
}
.quick-actions {
    display: flex;
    gap: 10px;
}
</style>
