<div class="mb-4">
    <a href="learning-paths.php">&larr; Back to Paths</a>
</div>

<h1><?= e($path['title']) ?></h1>
<p class="lead"><?= e($path['short_description']) ?></p>

<div class="timeline mt-4">
    <?php foreach ($steps as $step): ?>
        <div class="card mb-4">
            <div style="display: flex; align-items: center; gap: 1rem; margin-bottom: 1rem;">
                <div style="background: var(--primary-color); color: white; width: 40px; height: 40px; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-weight: bold;">
                    <?= $step['day_number'] ?>
                </div>
                <h3 style="margin: 0;"><?= e($step['title']) ?></h3>
            </div>
            
            <div class="step-content">
                <?= nl2br(e($step['content'])) ?>
            </div>
            
            <?php if (!empty($step['suggested_tools'])): ?>
                <div class="mt-4 pt-4 border-top">
                    <strong>Suggested Tools:</strong>
                    <div class="mt-2" style="display: flex; gap: 10px;">
                        <?php 
                        $tools = explode(',', $step['suggested_tools']);
                        foreach ($tools as $tool): 
                            $toolName = ucwords(str_replace('_', ' ', $tool));
                            $link = 'tools/' . str_replace('_', '-', $tool) . '.php';
                        ?>
                            <a href="<?= base_url($link) ?>" class="btn btn-sm btn-secondary"><?= $toolName ?></a>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    <?php endforeach; ?>
</div>
