<h2>Breathing Exercise</h2>
<p>Follow the rhythm to calm your mind.</p>

<div class="card text-center mb-4" style="display: flex; justify-content: center; align-items: center; min-height: 300px;">
    <div id="breathing-circle" style="
        width: 200px; 
        height: 200px; 
        background-color: rgba(16, 185, 129, 0.2); 
        border: 2px solid var(--success-color); 
        border-radius: 50%; 
        display: flex; 
        justify-content: center; 
        align-items: center; 
        transition: transform 4s ease-in-out;
    ">
        <h2 id="breath-text" style="margin: 0; color: var(--success-color);">Ready</h2>
    </div>
</div>

<div class="text-center">
    <button id="start-breath-btn" class="btn btn-primary" onclick="startBreathing()">Start Session</button>
</div>

<script>
function startBreathing() {
    const text = document.getElementById('breath-text');
    const circle = document.getElementById('breathing-circle');
    const btn = document.getElementById('start-breath-btn');
    
    btn.style.display = 'none';
    text.innerText = "Inhale";
    
    let cycles = 0;
    const maxCycles = 5; // 5 cycles for a quick session
    
    function breathe() {
        if (cycles >= maxCycles) {
            text.innerText = "Done";
            circle.style.transform = "scale(1)";
            btn.style.display = 'inline-block';
            btn.innerText = "Start Again";
            logSession();
            return;
        }
        
        // Inhale
        text.innerText = "Inhale";
        circle.style.transform = "scale(1.5)";
        
        setTimeout(() => {
            // Hold
            text.innerText = "Hold";
            
            setTimeout(() => {
                // Exhale
                text.innerText = "Exhale";
                circle.style.transform = "scale(1.0)";
                
                cycles++;
                setTimeout(breathe, 4000); // Wait for exhale to finish before next loop
            }, 2000); // Hold 2s
        }, 4000); // Inhale 4s
    }
    
    breathe();
}

function logSession() {
    fetch('<?= base_url('api/tools/breathing.php') ?>', {
        method: 'POST'
    }).then(res => res.json())
      .then(data => console.log('Session logged:', data))
      .catch(err => console.error('Error logging session:', err));
}
</script>
