<h2>Focus Timer</h2>
<p>Stay focused with the Pomodoro technique.</p>

<div class="card text-center mb-4">
    <h1 id="time-display" style="font-size: 4rem; font-weight: 700; color: var(--primary-color);">25:00</h1>
    <div class="mt-4">
        <button id="start-timer-btn" class="btn btn-primary" onclick="startTimer()">Start</button>
        <button id="pause-timer-btn" class="btn btn-secondary" onclick="pauseTimer()" style="display:none;">Pause</button>
        <button id="reset-timer-btn" class="btn btn-danger" onclick="resetTimer()">Reset</button>
    </div>
</div>

<script>
let timerInterval;
let defaultTime = 25 * 60;
let timeLeft = defaultTime;
let isRunning = false;

function updateDisplay() {
    const minutes = Math.floor(timeLeft / 60);
    const seconds = timeLeft % 60;
    document.getElementById('time-display').innerText = 
        `${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;
}

function startTimer() {
    if (isRunning) return;
    isRunning = true;
    document.getElementById('start-timer-btn').style.display = 'none';
    document.getElementById('pause-timer-btn').style.display = 'inline-block';
    
    timerInterval = setInterval(() => {
        if (timeLeft > 0) {
            timeLeft--;
            updateDisplay();
        } else {
            completeSession();
        }
    }, 1000);
}

function pauseTimer() {
    clearInterval(timerInterval);
    isRunning = false;
    document.getElementById('start-timer-btn').style.display = 'inline-block';
    document.getElementById('pause-timer-btn').style.display = 'none';
}

function resetTimer() {
    pauseTimer();
    timeLeft = defaultTime;
    updateDisplay();
}

function completeSession() {
    pauseTimer();
    alert("Time's up! Take a break.");
    logSession(25);
    timeLeft = defaultTime;
    updateDisplay();
}

function logSession(minutes) {
    fetch('<?= base_url('api/tools/focus.php') ?>', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ minutes: minutes })
    }).then(res => res.json())
      .then(data => console.log('Session logged:', data))
      .catch(err => console.error('Error logging session:', err));
}
</script>
